<?php 

class ControllerBulkActivationLog extends Controller { 
	private $activation = array();

	public function index() {		
		// var_dump("expression");exit();
		$this->language->load('bulk/activation_log');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->data['heading_title'] = $this->language->get('heading_title');
		 $this->data['button_pdf'] = $this->language->get('button_pdf');
		$this->data['button_clear'] = $this->language->get('button_clear');

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),       		
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('bulk/activation_log', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['clear'] = $this->url->link('bulk/activation_log/clear', 'token=' . $this->session->data['token'], 'SSL');
		$this->data['printPdf'] = $this->url->link('bulk/activation_log/printPdf', 'token=' . $this->session->data['token'], 'SSL');
		
		// $file = DIR_LOGS . $this->config->get('config_activation_filename');
		$file = DIR_LOGS . 'sms_stb_activation.txt';
		
		if (file_exists($file)) {
			// $this->data['log'] = file_get_contents($file, FILE_USE_INCLUDE_PATH, null);
			$this->data['log'] = 'Click On Print For getting Box Activation and DeActivation Logs!!';
		} else {
			$this->data['log'] = '';
		}

		$this->template = 'bulk/activation_log.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}

	public function printPdf(){
  		$pdf = new FPDF();
		$pdf->AddPage();
		$start_x=$pdf->GetX(); 
		$current_y = $pdf->GetY();
		$current_x = $pdf->GetX();

		$pdf->SetFont('Arial','',10);
		$file = DIR_LOGS.'sms_stb_activation.txt';
		if(file_exists($file)){		
			$contents = file_get_contents($file);
			$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
			$current_date = $currDate->format('d-m-Y H:i:s');	
			$pdf->Write(14,"(SMS) STB ACTIVATION / De-ACTIVATION LOG");
			$pdf->Write(8,"\n");
			$pdf->Write(14,"DATE : ");
			$pdf->Write(14,$current_date);
			$pdf->Write(8,"\n");
			$pdf->Write(8,"------------------------------------------------------------------------------------------------------------------------------------------------------------\n");
			$pdf->Write(8,$contents);

			$pdf->Output();
		}else{
			$pdf->Write(8,"FILE MISSING");
			$pdf->Output();
		}
    }

}
?>