<?php  
/*
@File return_reason.php(MODEL)
LOCALISATION:	 RETURN_REASON PAGE
    Manages reason for the return of the product by the customer

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationReturnReason extends Model {
/*
FUNCTION NAME 		-	addReturnReason
DESCRIPTION 		-	Inserts the reason for the return order by the customer with all the retrun detail given.
INPUT PARAMETER 	-	data array having return reason imformation
OUTPUT PARAMETER 	- 	void
*/	
	public function addReturnReason($data) {
		foreach ($data['return_reason'] as $language_id => $value) {
			if (isset($return_reason_id)) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "return_reason SET return_reason_id = '" . (int)$return_reason_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
			} else {
				$this->db->query("INSERT INTO " . DB_PREFIX . "return_reason SET language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
				
				$return_reason_id = $this->db->getLastId();
			}
		}
		
		$this->cache->delete('return_reason');
	}
/*
FUNCTION NAME 		-	editReturnReason
DESCRIPTION 		-	Edits the return reason for the order that is already returned. 
INPUT PARAMETER 	-	return_reason_id and data array for the updation of the return reason
OUTPUT PARAMETER 	- 	void
*/
	public function editReturnReason($return_reason_id, $data) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "return_reason WHERE return_reason_id = '" . (int)$return_reason_id . "'");

		foreach ($data['return_reason'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "return_reason SET return_reason_id = '" . (int)$return_reason_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}
				
		$this->cache->delete('return_reason');
	}
/*
FUNCTION NAME 		-	deleteReturnReason
DESCRIPTION 		-	Deletes the return reason for the returned order for the given return_reason_id.
INPUT PARAMETER 	-	return_reason_id
OUTPUT PARAMETER 	- 	void
*/	
	public function deleteReturnReason($return_reason_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "return_reason WHERE return_reason_id = '" . (int)$return_reason_id . "'");
	
		$this->cache->delete('return_reason');
	}
/*
FUNCTION NAME 		-	getReturnReason
DESCRIPTION 		-	Retrieve the return reason for the given return_reason_id
INPUT PARAMETER 	-	return_reason_id
OUTPUT PARAMETER 	- 	Returns a row containing detals for the return.
*/		
	public function getReturnReason($return_reason_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "return_reason WHERE return_reason_id = '" . (int)$return_reason_id . "' AND language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getReturnReasons
DESCRIPTION 		-	Retrieve all the return reason for the configured language_id
INPUT PARAMETER 	-	data array containing filter options if any.
OUTPUT PARAMETER 	- 	Returns an array containing the queried rows containing the return reasons
*/		
	public function getReturnReasons($data = array()) {
      	if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "return_reason WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'";
			
			$sql .= " ORDER BY name";	
			
			if (isset($data['return']) && ($data['return'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			
			$query = $this->db->query($sql);
			
			return $query->rows;
		} else {
			$return_reason_data = $this->cache->get('return_reason.' . (int)$this->config->get('config_language_id'));
		
			if (!$return_reason_data) {
				$query = $this->db->query("SELECT return_reason_id, name FROM " . DB_PREFIX . "return_reason WHERE language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY name");
	
				$return_reason_data = $query->rows;
			
				$this->cache->set('return_reason.' . (int)$this->config->get('config_language_id'), $return_reason_data);
			}	
	
			return $return_reason_data;				
		}
	}
/*
FUNCTION NAME 		-	getReturnReasonDescription
DESCRIPTION 		-	Based on the return_reason_id, it retrieves the description for the selected id.
INPUT PARAMETER 	-	return_reason_id
OUTPUT PARAMETER 	- 	Returns an array containing all the rows retrieved for the description of the return reason
*/	
	public function getReturnReasonDescriptions($return_reason_id) {
		$return_reason_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "return_reason WHERE return_reason_id = '" . (int)$return_reason_id . "'");
		
		foreach ($query->rows as $result) {
			$return_reason_data[$result['language_id']] = array('name' => $result['name']);
		}
		
		return $return_reason_data;
	}
/*
FUNCTION NAME 		-	getTotalReturnsReasons
DESCRIPTION 		-	Retrieves the count of total return reason.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column for the retrieved row containing the total number of count
*/	
	public function getTotalReturnReasons() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "return_reason WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row['total'];
	}	
}
?>