<?php 
/*
@File voucher_theme.php(MODEL)
CHECKOUT:	 VOUCHER_THEME PAGE
    Manages the voucher theme by retrieving it on its id

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCheckoutVoucherTheme extends Model {
/*
FUNCTION NAME 		-	getVoucherTheme
DESCRIPTION 		-	Retrieves the voucher theme for the given voucher_theme_id.
INPUT PARAMETER 	-	voucher_theme_id
OUTPUT PARAMETER 	- 	Returns a row containing the voucher theme details for the selected id.
*/	
	public function getVoucherTheme($voucher_theme_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "voucher_theme vt LEFT JOIN " . DB_PREFIX . "voucher_theme_description vtd ON (vt.voucher_theme_id = vtd.voucher_theme_id) WHERE vt.voucher_theme_id = '" . (int)$voucher_theme_id . "' AND vtd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getVoucherThemes
DESCRIPTION 		-	Retrieves all the voucher theme that is stored in the database.
INPUT PARAMETER 	-	data array conatining filter options if any
OUTPUT PARAMETER 	- 	Returns all the voucher theme rows if the data array is set else returns the default theme for the voucher.
*/		
	public function getVoucherThemes($data = array()) {
      	if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "voucher_theme vt LEFT JOIN " . DB_PREFIX . "voucher_theme_description vtd ON (vt.voucher_theme_id = vtd.voucher_theme_id) WHERE vtd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY vtd.name";	
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			
			$query = $this->db->query($sql);
			
			return $query->rows;
		} else {
			$voucher_theme_data = $this->cache->get('voucher_theme.' . (int)$this->config->get('config_language_id'));
		
			if (!$voucher_theme_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "voucher_theme vt LEFT JOIN " . DB_PREFIX . "voucher_theme_description vtd ON (vt.voucher_theme_id = vtd.voucher_theme_id) WHERE vtd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY vtd.name");
	
				$voucher_theme_data = $query->rows;
			
				$this->cache->set('voucher_theme.' . (int)$this->config->get('config_language_id'), $voucher_theme_data);
			}	
	
			return $voucher_theme_data;				
		}
	}
}
?>