<?php
/*
@File review.php(MODEL)
CATALOG:	 REVIEW PAGE
    Manages the review details for any product by adding or retrieving the details.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCatalogReview extends Model {	
/*
FUNCTION NAME 		-	addReview
DESCRIPTION 		-	Adds review for the selected product with the details given by the customer.
INPUT PARAMETER 	-	product_id and data array containing the customer's review about the product.
OUTPUT PARAMETER 	- 	void.
*/	
	public function addReview($product_id, $data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "review SET author = '" . $this->db->escape($data['name']) . "', customer_id = '" . (int)$this->customer->getId() . "', product_id = '" . (int)$product_id . "', text = '" . $this->db->escape($data['text']) . "', rating = '" . (int)$data['rating'] . "', date_added = NOW()");
	}
/*
FUNCTION NAME 		-	getReviewsByProductId
DESCRIPTION 		-	Retrieving all the reviews written for the selected product. 
INPUT PARAMETER 	-	product_id and start and limit variable for portion vise retrieval.
OUTPUT PARAMETER 	- 	Returns a  all the rows matched with the product_id containing review descripiton for the product.
*/		
	public function getReviewsByProductId($product_id, $start = 0, $limit = 20) {
		if ($start < 0) {
			$start = 0;
		}
		
		if ($limit < 1) {
			$limit = 20;
		}		
		
		$query = $this->db->query("SELECT r.review_id, r.author, r.rating, r.text, p.product_id, pd.name, p.price, p.image, r.date_added FROM " . DB_PREFIX . "review r LEFT JOIN " . DB_PREFIX . "product p ON (r.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int)$product_id . "' AND p.date_available <= NOW() AND p.status = '1' AND r.status = '1' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY r.date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
			
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalReviewsByProductId
DESCRIPTION 		-	Retrieveing count of all the review written on the selected product
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns the count as row column value in total.
*/
	public function getTotalReviewsByProductId($product_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "review r LEFT JOIN " . DB_PREFIX . "product p ON (r.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int)$product_id . "' AND p.date_available <= NOW() AND p.status = '1' AND r.status = '1' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row['total'];
	}
}
?>