<?php
/*
@File transaction.php(MODEL)
AFFILIATE:	 TRANSACTION PAGE
    Manages the tranaction made by the affiliate

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelAffiliateTransaction extends Model {	
/*
FUNCTION NAME 		-	getTransactions
DESCRIPTION 		-	Retrieves all the transactions associated with the current affiliate. 
INPUT PARAMETER 	-	data array containing filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows conatining the details of all the transaction of the affiliate
*/	
	public function getTransactions($data = array()) {
		$sql = "SELECT * FROM `" . DB_PREFIX . "affiliate_transaction` WHERE affiliate_id = '" . (int)$this->affiliate->getId() . "'";
		   
		$sort_data = array(
			'amount',
			'description',
			'date_added'
		);
	
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY date_added";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);
	
		return $query->rows;
	}	
/*
FUNCTION NAME 		-	getTotalTransactions
DESCRIPTION 		-	Retrieves a row conatining count for the total number of transaction row retrieved.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column of the row containing total no. of transactions of the current affiliate
*/		
	public function getTotalTransactions() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "affiliate_transaction` WHERE affiliate_id = '" . (int)$this->affiliate->getId() . "'");
			
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getBalance
DESCRIPTION 		-	Retrieves balance in the affiliate's account.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column of the row containing sum of amounts of the current affiliate or returns 0 if no row selected
*/			
	public function getBalance() {
		$query = $this->db->query("SELECT SUM(amount) AS total FROM `" . DB_PREFIX . "affiliate_transaction` WHERE affiliate_id = '" . (int)$this->affiliate->getId() . "' GROUP BY affiliate_id");
		
		if ($query->num_rows) {
			return $query->row['total'];
		} else {
			return 0;	
		}
	}
}
?>