<?php
/*
@File customer_group.php(MODEL)
CUSTOMER: 	CUSTOMER_GROUP PAGE
    		Manages the Customer group information and its details by retrieving it from the database. 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelAccountCustomerGroup extends Model {
/*
FUNCTION NAME 		-	getCustomerGroup
DESCRIPTION 		-	Retrieves the customer group information of the given customer_group_id
INPUT PARAMETER 	-	customer_group_id
OUTPUT PARAMETER 	- 	Returns a row containing the selected customer group information
*/

	public function getCustomerGroup($customer_group_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer_group cg LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (cg.customer_group_id = cgd.customer_group_id) WHERE cg.customer_group_id = '" . (int)$customer_group_id . "' AND cgd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCustomerGroups
DESCRIPTION 		-	Retrieves all the customer group information.
INPUT PARAMETER 	-	void 
OUTPUT PARAMETER 	- 	Returns al the rows retrieved form the query. 
*/
	
	public function getCustomerGroups() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_group cg LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (cg.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY cg.sort_order ASC, cgd.name ASC");
		
		return $query->rows;
	}
}
?>
