<?php 
 /*
@File welcome.php(Controller/module)
WELCOME PAGE
    This class manages the welcome message for the customer

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerModuleWelcome extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Retrieves and assigns the welcome message
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	welcome message
*/	
	protected function index($setting) {
		$this->language->load('module/welcome');
		
    	$this->data['heading_title'] = sprintf($this->language->get('heading_title'), $this->config->get('config_name'));
//Assigning message vaiable    	
		$this->data['message'] = html_entity_decode($setting['description'][$this->config->get('config_language_id')], ENT_QUOTES, 'UTF-8');
/*Check if the template file other than the default theme for the welcome exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the welcome
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/welcome.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/welcome.tpl';
		} else {
			$this->template = 'default/template/module/welcome.tpl';
		}
		
		$this->render();
	}
}
?>