<?php   
/*
@File store.php(Controller/module)
STORE PAGE
    This class manages the store when there are multiple stored 
    configured. It ask for the store selection and renders the 
    content of the selected store

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerModuleStore extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the module for store for selection. If there is only one
						store, it loads automatically as the default.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Store Content
*/	
	protected function index() {
		$status = true;
		
		if ($this->config->get('store_admin')) {
			$this->load->library('user');
		
			$this->user = new User($this->registry);
			
			$status = $this->user->isLogged();
		}
		
		if ($status) {
//Loads language for store
			$this->language->load('module/store');
//Assigning page variables.			
			$this->data['heading_title'] = $this->language->get('heading_title');
			
			$this->data['text_store'] = $this->language->get('text_store');
			
			$this->data['store_id'] = $this->config->get('config_store_id');
			
			$this->data['stores'] = array();
			
			$this->data['stores'][] = array(
				'store_id' => 0,
				'name'     => $this->language->get('text_default'),
				'url'      => HTTP_SERVER . 'index.php?route=common/home&session_id=' . $this->session->getId()
			);
			
			$this->load->model('setting/store');
//Retrieving different stores form the database			
			$results = $this->model_setting_store->getStores();
//Assigning store information to array variable			
			foreach ($results as $result) {
				$this->data['stores'][] = array(
					'store_id' => $result['store_id'],
					'name'     => $result['name'],
					'url'      => $result['url'] . 'index.php?route=common/home&session_id=' . $this->session->getId()
				);
			}
/*Check if the template file other than the default theme for the store exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the store
*/	
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/store.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/module/store.tpl';
			} else {
				$this->template = 'default/template/module/store.tpl';
			}
			
			$this->render();
		}
	}
}
?>