<?php
/*
@File latest.php(Controller/module)
LATEST PAGE
    This class manages the latest channels from the whole list of channels. 
    This is done based on the channels recently added by the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerModuleLatest extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the latest channels with there basic information. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Latest channels
*/	
	protected function index($setting) {
//Loads the language for latest
		$this->language->load('module/latest');
//Assign the language variable
      	$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['button_cart'] = $this->language->get('button_cart');
//Loads the model for product and image				
		$this->load->model('catalog/product');
		
		$this->load->model('tool/image');
		
		$this->data['products'] = array();
//Assign array variable for appearance	
		$data = array(
			'sort'  => 'p.date_added',
			'order' => 'DESC',
			'start' => 0,
			'limit' => $setting['limit']
		);
//Retrieving channels based on the array defined above.
		$results = $this->model_catalog_product->getProducts($data);

		foreach ($results as $result) {
//Assigning channel image			
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $setting['image_width'], $setting['image_height']);
			} else {
				$image = false;
			}
//Assigning channel price						
			if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
				$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$price = false;
			}
//Assigning special if any					
			if ((float)$result['special']) {
				$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')));
			} else {
				$special = false;
			}
//Assigning channel review			
			if ($this->config->get('config_review_status')) {
				$rating = $result['rating'];
			} else {
				$rating = false;
			}
//Assigning channels detials to an array			
			$this->data['products'][] = array(
				'product_id' => $result['product_id'],
				'thumb'   	 => $image,
				'name'    	 => $result['name'],
				'price'   	 => $price,
				'special' 	 => $special,
				'rating'     => $rating,
				'reviews'    => sprintf($this->language->get('text_reviews'), (int)$result['reviews']),
				'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id']),
			);
		}
/*Check if the template file other than the default theme for the latest exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the latest
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/latest.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/latest.tpl';
		} else {
			$this->template = 'default/template/module/latest.tpl';
		}

		$this->render();
	}
}
?>