<?php  
/*
@File language.php(Controller/module)
LANGUAGE PAGE
    This class loads the language module on the header. Shows different languages added to the store.
    Switching of language can happen by clicking on the language icons.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerModuleLanguage extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the languages added to the store
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	List of languages
*/		
	protected function index() {
//Check for the language code if set in the url				
    	if (isset($this->request->post['language_code'])) {
			$this->session->data['language'] = $this->request->post['language_code'];
		
			if (isset($this->request->post['redirect'])) {
				$this->redirect($this->request->post['redirect']);
			} else {
				$this->redirect($this->url->link('common/home'));
			}
    	}		
//Loads the language for language			
		$this->language->load('module/language');
		
		$this->data['text_language'] = $this->language->get('text_language');
		
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$connection = 'SSL';
		} else {
			$connection = 'NONSSL';
		}
			
		$this->data['action'] = $this->url->link('module/language', '', $connection);

		$this->data['language_code'] = $this->session->data['language'];
//Loads the model for language		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = array();

		if (!isset($this->request->get['route'])) {
			$this->data['redirect'] = $this->url->link('common/home');
		} else {
			$data = $this->request->get;
			
			unset($data['_route_']);
			
			$route = $data['route'];
			
			unset($data['route']);
			
			$url = '';
			
			if ($data) {
				$url = '&' . urldecode(http_build_query($data, '', '&'));
			}	
					
			$this->data['redirect'] = $this->url->link($route, $url, $connection);
		}
		
//Retrieve the languages from the database			
		$results = $this->model_localisation_language->getLanguages();
//Assigning language details to an array		
		foreach ($results as $result) {
			if ($result['status']) {
				$this->data['languages'][] = array(
					'name'  => $result['name'],
					'code'  => $result['code'],
					'image' => $result['image'],
					'converted_name' => $this->language->get($result['name']),
					'href_link' => $this->data['redirect']
				);	
			}
		}

		
/*Check if the template file other than the default theme for the language exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the language
*/		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/language.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/language.tpl';
		} else {
			$this->template = 'default/template/module/language.tpl';
		}
		
		$this->render();
	}
}
?>