<?php  
/*
@File filter.php(Controller/module)
FILTER PAGE
    This class manages the filtered channels from the whole list. 
    This filteration can be done based on sort values, order i.e., ascending 
    or descending, limit (no. of channels to be shown) etc.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerModuleFilter extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the filtered channels with there basic information. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Filtered channels
*/		
	protected function index($setting) {
//Exploade the url if the path is set.		
		if (isset($this->request->get['path'])) {
			$parts = explode('_', (string)$this->request->get['path']);
		} else {
			$parts = array();
		}
		
		$category_id = end($parts);
//Loads model for category		
		$this->load->model('catalog/category');
//Retrieve category information of the selected category with id.		
		$category_info = $this->model_catalog_category->getCategory($category_id);
		
		if ($category_info) {
			$this->language->load('module/filter');
//Assigning page variables		
			$this->data['heading_title'] = $this->language->get('heading_title');
			
			$this->data['button_filter'] = $this->language->get('button_filter');
			
			$url = '';
//Modifying the url if sort filter is set			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}	
//Modifying the url if order filter is set
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}	
//Modifying the url if limit filter is set			
			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}
//Assigning action link 									
			$this->data['action'] = str_replace('&amp;', '&', $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url));
			
			if (isset($this->request->get['filter'])) {
				$this->data['filter_category'] = explode(',', $this->request->get['filter']);
			} else {
				$this->data['filter_category'] = array();
			}
			
			$this->load->model('catalog/product');

			$this->data['filter_groups'] = array();
//Retrieving filter groups based on the category id.			
			$filter_groups = $this->model_catalog_category->getCategoryFilters($category_id);
			
			if ($filter_groups) {
				foreach ($filter_groups as $filter_group) {
					$filter_data = array();
//Assigning filter details to an array					
					foreach ($filter_group['filter'] as $filter) {
						$data = array(
							'filter_category_id' => $category_id,
							'filter_filter'      => $filter['filter_id']
						);	
						
						$filter_data[] = array(
							'filter_id' => $filter['filter_id'],
							'name'      => $filter['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($data) . ')' : '')
						);
					}
					
					$this->data['filter_groups'][] = array(
						'filter_group_id' => $filter_group['filter_group_id'],
						'name'            => $filter_group['name'],
						'filter'          => $filter_data
					);
				} 
/*Check if the template file other than the default theme for the filter exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the filter
*/			
				if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/filter.tpl')) {
					$this->template = $this->config->get('config_template') . '/template/module/filter.tpl';
				} else {
					$this->template = 'default/template/module/filter.tpl';
				}
				
				$this->render();
			}
		}
  	}
}
?>