<?php
/*
@File featured.php(Controller/module)
FEATURED PAGE
    This class manages the home page featured div content of the store. 
    The content contains all the enabled packages in the store with 
    its basic information

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerModuleFeatured extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the home page featured module containg enabled packages.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Enabled packages
*/	
	protected function index($setting) {
//Loads the language for featured		
		$this->language->load('module/featured'); 
//Assigning page variables
      	$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['button_cart'] = $this->language->get('button_cart');

		$this->data['Basic_value_text'] = $this->language->get('Basic_value_text');
		$this->data['check_details'] = $this->language->get('check_details');
//Assigning model for product and image		
		$this->load->model('catalog/product'); 
		
		$this->load->model('tool/image');

		$this->data['products'] = array();

		$products = explode(',', $this->config->get('featured_product'));
		if ((int)$setting['limit']==0) {
			$setting['limit'] = 5;
			//$setting['limit'] = 10;
		}
		
		$products = array_slice($products, 0, (int)$setting['limit']);
//Traversing each packages for its detail		
		foreach ($products as $product_id) {
//Retrieving package information form the database based on its id.
			$product_info = $this->model_catalog_product->getProduct($product_id);
			
			if ($product_info) {
//Assigning variable for image				
				if ($product_info['image']) {
					$image = $this->model_tool_image->resize($product_info['image'], $setting['image_width'], $setting['image_height']);
				} else {
					$image = false;
				}
//Assigning price variable
				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$price = false;
				}
//Assigning special discounts if any						
				if ((float)$product_info['special']) {
					$special = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$special = false;
				}
				
				if ($this->config->get('config_review_status')) {
					$rating = $product_info['rating'];
				} else {
					$rating = false;
				}
//Assigning package details to an array					
				$this->data['products'][] = array(
					'product_id' => $product_info['product_id'],
					'thumb'   	 => $image,
					'name'    	 => $product_info['name'],
					'price'   	 => $price,
					'special' 	 => $special,
					'rating'     => $rating,
					'reviews'    => sprintf($this->language->get('text_reviews'), (int)$product_info['reviews']),
					'href'    	 => $this->url->link('product/product', 'product_id=' . $product_info['product_id'])
				);
			}
		}
/*Check if the template file other than the default theme for the featured exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the featured
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/featured.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/featured.tpl';
		} else {
			$this->template = 'default/template/module/featured.tpl';
		}

		$this->render();
	}
}
?>