<?php  
/*
@File currency.php(Controller/module)
CURRENCY PAGE
    This class loads the currency module on the header. Shows different currency added to the store.
    Switching of currency can happen by clicking on the currency icons.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerModuleCurrency extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the currencies added to the store
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	List of currencies
*/		
	protected function index() {
//Check for the currency code if set in the url		
		if (isset($this->request->post['currency_code'])) {
      		$this->currency->set($this->request->post['currency_code']);
			
			unset($this->session->data['shipping_method']);
			unset($this->session->data['shipping_methods']);
			
			if (isset($this->request->post['redirect'])) {
				$this->redirect($this->request->post['redirect']);
			} else {
				$this->redirect($this->url->link('common/home'));
			}
   		}
//Loads the language for currency		
		$this->language->load('module/currency');
		
    	$this->data['text_currency'] = $this->language->get('text_currency');

		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$connection = 'SSL';
		} else {
			$connection = 'NONSSL';
		}
		
		$this->data['action'] = $this->url->link('module/currency', '', $connection);
		
		$this->data['currency_code'] = $this->currency->getCode(); 
//Loads model for currency		
		$this->load->model('localisation/currency');
		 
		 $this->data['currencies'] = array();
//Retrieve the currencies from the database		 
		$results = $this->model_localisation_currency->getCurrencies();	
//Assigning currency information to an array		
		foreach ($results as $result) {
			if ($result['status']) {
   				$this->data['currencies'][] = array(
					'title'        => $result['title'],
					'code'         => $result['code'],
					'symbol_left'  => $result['symbol_left'],
					'symbol_right' => $result['symbol_right']				
				);
			}
		}
		
		if (!isset($this->request->get['route'])) {
			$this->data['redirect'] = $this->url->link('common/home');
		} else {
			$data = $this->request->get;
			
			unset($data['_route_']);
			
			$route = $data['route'];
			
			unset($data['route']);
			
			$url = '';
			
			if ($data) {
				$url = '&' . urldecode(http_build_query($data, '', '&'));
			}	
						
			$this->data['redirect'] = $this->url->link($route, $url, $connection);
		}	
/*Check if the template file other than the default theme for the currency exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the currency
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/currency.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/currency.tpl';
		} else {
			$this->template = 'default/template/module/currency.tpl';
		}
		
		$this->render();
	}
}
?>