<?php  
/*
@File affiliate.php(Controller/module)
AFFILIATE PAGE
    This class assings the page variables and link variables of the affiliate page of the affiliater.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerModuleAffiliate extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Assigning of affiliate page variables
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Affiliate variables
*/	
	protected function index() {
//Loads language for affiliate			
		$this->language->load('module/affiliate');
//Assigning page variables.			
    	$this->data['heading_title'] = $this->language->get('heading_title');
    	
		$this->data['text_register'] = $this->language->get('text_register');
    	$this->data['text_login'] = $this->language->get('text_login');
		$this->data['text_logout'] = $this->language->get('text_logout');
		$this->data['text_forgotten'] = $this->language->get('text_forgotten');	
		$this->data['text_account'] = $this->language->get('text_account');
		$this->data['text_edit'] = $this->language->get('text_edit');
		$this->data['text_password'] = $this->language->get('text_password');
		$this->data['text_payment'] = $this->language->get('text_payment');
		$this->data['text_tracking'] = $this->language->get('text_tracking');
		$this->data['text_transaction'] = $this->language->get('text_transaction');
//Assigning link variables of the affiliate page.				
		$this->data['logged'] = $this->affiliate->isLogged();
		$this->data['register'] = $this->url->link('affiliate/register', '', 'SSL');
    	$this->data['login'] = $this->url->link('affiliate/login', '', 'SSL');
		$this->data['logout'] = $this->url->link('affiliate/logout', '', 'SSL');
		$this->data['forgotten'] = $this->url->link('affiliate/forgotten', '', 'SSL');
		$this->data['account'] = $this->url->link('affiliate/account', '', 'SSL');
		$this->data['edit'] = $this->url->link('affiliate/edit', '', 'SSL');
		$this->data['password'] = $this->url->link('affiliate/password', '', 'SSL');
		$this->data['payment'] = $this->url->link('affiliate/payment', '', 'SSL');
		$this->data['tracking'] = $this->url->link('affiliate/tracking', '', 'SSL');
		$this->data['transaction'] = $this->url->link('affiliate/transaction', '', 'SSL');
/*Check if the template file other than the default theme for the affiliate exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the affiliate
*/		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/affiliate.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/affiliate.tpl';
		} else {
			$this->template = 'default/template/module/affiliate.tpl';
		}
		
		$this->render();
	}
}
?>