<?php 
/*
@File not_found.php(Controller)
NOT_FOUND PAGE
    This class is used when the url requested is not found and displays the message.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/   
class ControllerErrorNotFound extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the not found message. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Not found message
*/	
	public function index() {		
		$this->language->load('error/not_found');
		
		$this->document->setTitle($this->language->get('heading_title'));
//Short-hand links to path as breadcrumbs		
		$this->data['breadcrumbs'] = array();
 
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),
        	'separator' => false
      	);		
		
		if (isset($this->request->get['route'])) {
			$data = $this->request->get;
			
			unset($data['_route_']);
			
			$route = $data['route'];
			
			unset($data['route']);
			
			$url = '';
			
			if ($data) {
				$url = '&' . urldecode(http_build_query($data, '', '&'));
			}	
			
			if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
				$connection = 'SSL';
			} else {
				$connection = 'NONSSL';
			}
//Adding short-hand link is the page is not found											
       		$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link($route, $url, $connection),
        		'separator' => $this->language->get('text_separator')
      		);	   	
		}
//Assigning page variables		
		$this->data['heading_title'] = $this->language->get('heading_title');
//Assigning error text message		
		$this->data['text_error'] = $this->language->get('text_error');
		
		$this->data['button_continue'] = $this->language->get('button_continue');
		
		$this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . '/1.1 404 Not Found');
		
		$this->data['continue'] = $this->url->link('common/home');
/*Check if the template file other than the default theme for the not_found exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the not_found
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/error/not_found.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/error/not_found.tpl';
		} else {
			$this->template = 'default/template/error/not_found.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'
		);
		
		$this->response->setOutput($this->render());
  	}
}
?>