<?php
/*
@File login.php(Controller)
LOGIN PAGE
    Loads the login page if the guest is checking out the order without login. 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerCheckoutLogin extends Controller { 
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the login form and registration link to login at the time
						of checkout.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Login form
*/	
	public function index() {
//Loads the language for checkout
		$this->language->load('checkout/checkout');
//Assign page variables.		
		$this->data['text_new_customer'] = $this->language->get('text_new_customer');
		$this->data['text_returning_customer'] = $this->language->get('text_returning_customer');
		$this->data['text_checkout'] = $this->language->get('text_checkout');
		$this->data['text_register'] = $this->language->get('text_register');
		$this->data['text_guest'] = $this->language->get('text_guest');
		$this->data['text_i_am_returning_customer'] = $this->language->get('text_i_am_returning_customer');
		$this->data['text_register_account'] = $this->language->get('text_register_account');
		$this->data['text_forgotten'] = $this->language->get('text_forgotten');
 
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_password'] = $this->language->get('entry_password');
		
		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_login'] = $this->language->get('button_login');
		
		$this->data['guest_checkout'] = ($this->config->get('config_guest_checkout') && !$this->config->get('config_customer_price') && !$this->cart->hasDownload());
		
		if (isset($this->session->data['account'])) {
			$this->data['account'] = $this->session->data['account'];
		} else {
			$this->data['account'] = 'register';
		}
		
		$this->data['forgotten'] = $this->url->link('account/forgotten', '', 'SSL');
/*Check if the template file other than the default theme for the login exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the login
*/		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/checkout/login.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/checkout/login.tpl';
		} else {
			$this->template = 'default/template/checkout/login.tpl';
		}
				
		$this->response->setOutput($this->render());
	}
/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validate the login credentials and customer approval.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns TRUE if the validation satisfies else returns FALSE
*/ 	
	public function validate() {
//Loads the language for checkout
		$this->language->load('checkout/checkout');
		
		$json = array();
//Check if logged in		
		if ($this->customer->isLogged()) {
			$json['redirect'] = $this->url->link('checkout/checkout', '', 'SSL');			
		}
//Redirect if cart is empty		
		if ((!$this->cart->hasProducts() && empty($this->session->data['vouchers'])) || (!$this->cart->hasStock() && !$this->config->get('config_stock_checkout'))) {
			$json['redirect'] = $this->url->link('checkout/cart');
		}	
//Validate login credentials		
		if (!$json) {
			if (!$this->customer->login($this->request->post['email'], $this->request->post['password'])) {
				$json['error']['warning'] = $this->language->get('error_login');
			}
		
			$this->load->model('account/customer');
//Retrieve customer information		
			$customer_info = $this->model_account_customer->getCustomerByEmail($this->request->post['email']);
			
			if ($customer_info && !$customer_info['approved']) {
				$json['error']['warning'] = $this->language->get('error_approved');
			}		
		}
		
		if (!$json) {
			unset($this->session->data['guest']);
				
// Default Addresses
			$this->load->model('account/address');
//Retrieve address information of the logged in customer				
			$address_info = $this->model_account_address->getAddress($this->customer->getAddressId());
									
			if ($address_info) {
				if ($this->config->get('config_tax_customer') == 'shipping') {
					$this->session->data['shipping_country_id'] = $address_info['country_id'];
					$this->session->data['shipping_zone_id'] = $address_info['zone_id'];
					$this->session->data['shipping_postcode'] = $address_info['postcode'];	
				}
				
				if ($this->config->get('config_tax_customer') == 'payment') {
					$this->session->data['payment_country_id'] = $address_info['country_id'];
					$this->session->data['payment_zone_id'] = $address_info['zone_id'];
				}
			} else {
				unset($this->session->data['shipping_country_id']);	
				unset($this->session->data['shipping_zone_id']);	
				unset($this->session->data['shipping_postcode']);
				unset($this->session->data['payment_country_id']);	
				unset($this->session->data['payment_zone_id']);	
			}					
				
			$json['redirect'] = $this->url->link('checkout/checkout', '', 'SSL');
		}
					
		$this->response->setOutput(json_encode($json));		
	}
}
?>