
<?php 
/*
@File password.php(Controller)
AFFILIATE PASSWORD PAGE
    This class loads the password change form. But for this the affiliate
    should login to change his password.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerAffiliatePassword extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the form where affiliate can change his password.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Affiliate Change password form
*/	     
  	public function index() {	
/*Checks if the customer is logged in or not, if not redirect him to login page.*/
    	if (!$this->affiliate->isLogged()) {
      		$this->session->data['redirect'] = $this->url->link('affiliate/password', '', 'SSL');

      		$this->redirect($this->url->link('affiliate/login', '', 'SSL'));
    	}
//Loads language for password
		$this->language->load('affiliate/password');

    	$this->document->setTitle($this->language->get('heading_title'));
//Changes the password and updates the database is request method is POST and validation is true			  
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->load->model('affiliate/affiliate');
//Updates the password.			
			$this->model_affiliate_affiliate->editPassword($this->affiliate->getEmail(), $this->request->post['password']);
 
      		$this->session->data['success'] = $this->language->get('text_success');
//Redirect to account page.	  
	  		$this->redirect($this->url->link('affiliate/account', '', 'SSL'));
    	}
//Short-hand links to path as breadcrumbs
      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),       	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('affiliate/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
		
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('affiliate/password', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
//Assigning page variables.			
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['text_password'] = $this->language->get('text_password');

    	$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');

    	$this->data['button_continue'] = $this->language->get('button_continue');
    	$this->data['button_back'] = $this->language->get('button_back');
//Assigning error and warning variables.    	
		if (isset($this->error['password'])) { 
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) { 
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}
	
    	$this->data['action'] = $this->url->link('affiliate/password', '', 'SSL');
		
		if (isset($this->request->post['password'])) {
    		$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}

    	$this->data['back'] = $this->url->link('affiliate/account', '', 'SSL');
/*Check if the template file other than the default theme for the password exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the password
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/affiliate/password.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/affiliate/password.tpl';
		} else {
			$this->template = 'default/template/affiliate/password.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
								
		$this->response->setOutput($this->render());				
  	}
/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validate the password specified by the customer 
						for changing.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns TRUE if the validation satisfies else returns FALSE
*/  
  	protected function validate() {
//validation for password
    	if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
      		$this->error['password'] = $this->language->get('error_password');
    	}
//validation for confirm password
    	if ($this->request->post['confirm'] != $this->request->post['password']) {
      		$this->error['confirm'] = $this->language->get('error_confirm');
    	}  
	
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
}
?>
