<?php 
/*
@File logout.php(Controller)
AFFILIATE LOGOUT PAGE
    This class load the logout message when an affiliate logs out from his account.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerAffiliateLogout extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the affiliate logout page containing the logout message.
						
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Logout message
*/	
	public function index() {
/*Checks if the customer is logged in or not, if yes, log him out and redirect to logout page.*/
    	if ($this->affiliate->isLogged()) {
      		$this->affiliate->logout();
			
      		$this->redirect($this->url->link('affiliate/logout', '', 'SSL'));
    	}
 //Loads language for logout
    	$this->language->load('affiliate/logout');
		
		$this->document->setTitle($this->language->get('heading_title'));
//Short-hand links to path as breadcrumbs      	
		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),        	
        	'separator' => false
      	);
      	
		$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('affiliate/account', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
		
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_logout'),
			'href'      => $this->url->link('affiliate/logout', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);	
//Assigning page variables		
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['text_message'] = $this->language->get('text_message');

    	$this->data['button_continue'] = $this->language->get('button_continue');

    	$this->data['continue'] = $this->url->link('common/home');
/*Check if the template file other than the default theme for the success exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the success
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/success.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/success.tpl';
		} else {
			$this->template = 'default/template/common/success.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
  	}
}
?>