<?php 
/*
@File transaction.php(Controller)
CUSTOMER TRANSACTION PAGE
    This class is related to the transactions made by the cutomer against the orders
    he made. 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerAccountTransaction extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the customer transaction details from the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Transaction list, 10 in each page.
*/
	public function index() {
/*Checks if the customer is logged in or not, if not redirect him to login page.*/
		if (!$this->customer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('account/transaction', '', 'SSL');
			
	  		$this->redirect($this->url->link('account/login', '', 'SSL'));
    	}		
//Loads the language for transaction		
		$this->language->load('account/transaction');

		$this->document->setTitle($this->language->get('heading_title'));
//Short-hand links to the path as breadcrumbs
      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(       	
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
		
      	$this->data['breadcrumbs'][] = array(       	
        	'text'      => $this->language->get('text_transaction'),
			'href'      => $this->url->link('account/transaction', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
//Loading the model for transaction		
		$this->load->model('account/transaction');
//Assigning page variables
    	$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_description'] = $this->language->get('column_description');
		$this->data['column_amount'] = sprintf($this->language->get('column_amount'), $this->config->get('config_currency'));
		
		$this->data['text_total'] = $this->language->get('text_total');
		$this->data['text_empty'] = $this->language->get('text_empty');
		
		$this->data['button_continue'] = $this->language->get('button_continue');
				
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}		
		
		$this->data['transactions'] = array();
		
		$data = array(				  
			'sort'  => 'date_added',
			'order' => 'DESC',
			'start' => ($page - 1) * 10,
			'limit' => 10
		);
//Retrieving total transactions		
		$transaction_total = $this->model_account_transaction->getTotalTransactions($data);
//Assigning the transactions based on the data provided as an array	
		$results = $this->model_account_transaction->getTransactions($data);
//Assigning transaction details to an array. 		
    	foreach ($results as $result) {
			$this->data['transactions'][] = array(
				'amount'      => $this->currency->format($result['amount'], $this->config->get('config_currency')),
				'description' => $result['description'],
				'date_added'  => date($this->language->get('date_format_short'), strtotime($result['date_added']))
			);
		}	
//Pagination
		$pagination = new Pagination();
		$pagination->total = $transaction_total;
		$pagination->page = $page;
		$pagination->limit = 10; 
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('account/transaction', 'page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
		
		$this->data['total'] = $this->currency->format($this->customer->getBalance());
		
		$this->data['continue'] = $this->url->link('account/account', '', 'SSL');

/*Check if the template file other than the default theme for the transaction exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the transaction
*/		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/account/transaction.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/account/transaction.tpl';
		} else {
			$this->template = 'default/template/account/transaction.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());		
	} 		
}
?>