<?php 
/*@File password.php(Controller)
CUSTOMER ACCOUNT PASSWORD PAGE
    Customer can change his password by giving hi current password as validation

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerAccountPassword extends Controller {

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads form to change the customer password. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Change password form.
*/	
	private $error = array();
	     
  	public function index() {	
/*Checks if the customer is logged in or not, if not redirect him to login page.*/  		
    	if (!$this->customer->isLogged()) {
      		$this->session->data['redirect'] = $this->url->link('account/password', '', 'SSL');

      		$this->redirect($this->url->link('account/login', '', 'SSL'));
    	}
//Loads language for password
		$this->language->load('account/password');

    	$this->document->setTitle($this->language->get('heading_title'));
//if the request methos is POST and validate function is TRUE, the changed password is updated to the database.			  
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->load->model('account/customer');
//Adding the changed password to the database.			
			$this->model_account_customer->editPassword($this->customer->getEmail(), $this->request->post['password']);
 
      		$this->session->data['success'] = $this->language->get('text_success');
//Redirecting to the account page      		
	  		$this->redirect($this->url->link('account/account', '', 'SSL'));
	  		
    	}
//Short-hang to path as breadcrumbs.
      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),       	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
		
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('account/password', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
//Assigning page variables.			
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['text_password'] = $this->language->get('text_password');

    	$this->data['entry_curr_password'] = $this->language->get('entry_curr_password');
    	$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');

    	$this->data['button_continue'] = $this->language->get('button_continue');
    	$this->data['button_back'] = $this->language->get('button_back');
//Assigning errors and warning variables.    	
    	if (isset($this->error['curr_password'])) { 
			$this->data['error_curr_password'] = $this->error['curr_password'];
		} else {
			$this->data['error_curr_password'] = '';
		}

		if (isset($this->error['password'])) { 
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) { 
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}
	
    	$this->data['action'] = $this->url->link('account/password', '', 'SSL');
//Assigning variables.		
		if (isset($this->request->post['curr_password'])) {
    		$this->data['curr_password'] = '';//$this->request->post['curr_password'];
		} else {
			$this->data['curr_password'] = '';
		}

		if (isset($this->request->post['password'])) {
    		$this->data['password'] = '';//$this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = '';//$this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}

    	$this->data['back'] = $this->url->link('account/account', '', 'SSL');
/*Check if the template file other than the default theme for the password exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the password
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/account/password.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/account/password.tpl';
		} else {
			$this->template = 'default/template/account/password.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());			
  	}
 

/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validate the password specified by the customer 
						for changing.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns TRUE if the validation satisfies else returns FALSE
*/ 
  	protected function validate() {
  		$this->load->model('account/customer');
//validating current password  		
  		if ($this->request->post['curr_password']=='') {
      		$this->error['curr_password'] = $this->language->get('error_mandatory');
    	}
    	else{
	  		$pass_info = $this->model_account_customer->getCheckme($this->customer->getId(), $this->request->post['password'],$this->request->post['curr_password'],$this->customer->getEmail());
				if(!$pass_info){
					$this->error['curr_password'] = $this->language->get('error_curr_password');
					
				}

	  		if ((utf8_strlen($this->request->post['curr_password']) < 4) || (utf8_strlen($this->request->post['curr_password']) > 20)) {
	      		$this->error['curr_password'] = $this->language->get('error_curr_password');
	    	}
    	}

    //	$this->error['password'] = $this->language->get('error_password_curr');
//validating new password
    	if ($this->request->post['password']=='') {
      		$this->error['password'] = $this->language->get('error_mandatory');
    	}
    	elseif ($this->request->post['password'] == $this->request->post['curr_password']) {
    		$this->error['password'] = $this->language->get('error_password_curr');	
    	}
    	// else if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
     // 			$this->error['password'] = $this->language->get('error_password');
     //  	}
// //validating confirm password
    	if ($this->request->post['confirm'] =='') {
      		$this->error['confirm'] = $this->language->get('error_mandatory');
    	} 
    	else if ($this->request->post['confirm'] != $this->request->post['password']) {
      		//$this->error['warning']="Password doesn't match";
      		$this->error['confirm'] = "Password doesn't match";//$this->language->get('error_password');
    	}  

    	// if($this->request->post['confirm']!=$this->request->post['curr_password']){
    	// 	$this->error['warning']="Password doesn't match";
    	// }
	
		if (!$this->error) {
	  		return true;
		} else {
	  		return false;
		}
  	}
}
?>
