<?php 
/*
@File order.php(Controller)
CUSTOMER ORDER PAGE
    All the orders made by the customer is visible and can be managed from this page.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerAccountOrder extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the customer order template which shows the orders made
						by the customer. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Order list, 10 in each page.
*/
	private $error = array();
		
	public function index() {

/*Checks if the customer is logged in or not, if not redirect him to login page.*/
    	if (!$this->customer->isLogged()) {
      		$this->session->data['redirect'] = $this->url->link('account/order', '', 'SSL');

	  		$this->redirect($this->url->link('account/login', '', 'SSL'));
    	}
//Loads language for order		
		$this->language->load('account/order');
//loads order model		
		$this->load->model('account/order');
//if order id is set, retrieve the order information and the subscription detail		
		if (isset($this->request->get['order_id'])) {
			$order_info = $this->model_account_order->getOrder($this->request->get['order_id']);
			
			if ($order_info) {
				$order_products = $this->model_account_order->getOrderProducts($this->request->get['order_id']);
						
				foreach ($order_products as $order_product) {
					$option_data = array();
							
					$order_options = $this->model_account_order->getOrderOptions($this->request->get['order_id'], $order_product['order_product_id']);
							
					foreach ($order_options as $order_option) {
						if ($order_option['type'] == 'select' || $order_option['type'] == 'radio') {
							$option_data[$order_option['product_option_id']] = $order_option['product_option_value_id'];
						} elseif ($order_option['type'] == 'checkbox') {
							$option_data[$order_option['product_option_id']][] = $order_option['product_option_value_id'];
						} elseif ($order_option['type'] == 'text' || $order_option['type'] == 'textarea' || $order_option['type'] == 'date' || $order_option['type'] == 'datetime' || $order_option['type'] == 'time') {
							$option_data[$order_option['product_option_id']] = $order_option['value'];	
						} elseif ($order_option['type'] == 'file') {
							$option_data[$order_option['product_option_id']] = $this->encryption->encrypt($order_option['value']);
						}
					}
							
					$this->session->data['success'] = sprintf($this->language->get('text_success'), $this->request->get['order_id']);
							
					$this->cart->add($order_product['product_id'], $order_product['quantity'], $option_data);
				}
									
				$this->redirect($this->url->link('checkout/cart'));
			}
		}

    	$this->document->setTitle($this->language->get('heading_title'));
//Short-hand links to the path as breadcrumbs.
      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),        	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);
		
		$url = '';
/*each page contain some no. of orders. So the page selected is added to the url to retrieve the 
	selected page orders only.
*/		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
				
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('account/order', $url, 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);
//Assigning page variable.
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_order_id'] = $this->language->get('text_order_id');
		$this->data['text_status'] = $this->language->get('text_status');
		$this->data['text_date_added'] = $this->language->get('text_date_added');
		$this->data['text_customer'] = $this->language->get('text_customer');
		$this->data['text_products'] = $this->language->get('text_products');
		$this->data['text_time_added'] = $this->language->get('text_time_added');
		$this->data['text_total'] = $this->language->get('text_total');
		$this->data['text_empty'] = $this->language->get('text_empty');

		$this->data['button_view'] = $this->language->get('button_view');
		$this->data['button_reorder'] = $this->language->get('button_reorder');
		$this->data['button_continue'] = $this->language->get('button_continue');
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$this->data['orders'] = array();
//Retrieving total number of orders associated with the customer.		
		$order_total = $this->model_account_order->getTotalOrders();
//Retrieving 10 order each time. Each page containg 10 orders. This is done for pagination.		
		$results = $this->model_account_order->getOrders(($page - 1) * 10, 10); 
//Traversing each orders at a time		
		foreach ($results as $result) {
			$product_total = $this->model_account_order->getTotalOrderProductsByOrderId($result['order_id']);
			$voucher_total = $this->model_account_order->getTotalOrderVouchersByOrderId($result['order_id']);

// Assigning order details to an array.
			$this->data['orders'][] = array(
				'order_id'   => $result['order_id'],
				'name'       => $result['firstname'] . ' ' . $result['lastname'],
				'status'     => $result['status'],
				'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'time_added' => substr($result['date_added'],10),
				'products'   => ($product_total + $voucher_total),
				'total'      => $this->currency->format($result['total'], $result['currency_code'], $result['currency_value']),
				'href'       => $this->url->link('account/order/info', 'order_id=' . $result['order_id'], 'SSL'),
				'reorder'    => $this->url->link('account/order', 'order_id=' . $result['order_id'], 'SSL')
			);
		}
//Pagination
		$pagination = new Pagination();
		$pagination->total = $order_total;
		$pagination->page = $page;
		$pagination->limit = 10;
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('account/order', 'page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();

		$this->data['continue'] = $this->url->link('account/account', '', 'SSL');


/*Check if the template file other than the default theme for the order_list exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the order_list
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/account/order_list.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/account/order_list.tpl';
		} else {
			$this->template = 'default/template/account/order_list.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());				
	}

/*
FUNCTION NAME 		-	info
DESCRIPTION 		-	Retrieves the selected order information and assigns the values 
						to the page variables. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Selected order detialed information.
*/	
	
	public function info() { 
		$this->language->load('account/order');
//if order_id is set, assign it to a variable else assign 0.		
		if (isset($this->request->get['order_id'])) {
			$order_id = $this->request->get['order_id'];
		} else {
			$order_id = 0;
		}	
/*Checks if the customer is logged in or not, if not redirect him to login page.*/
		if (!$this->customer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('account/order/info', 'order_id=' . $order_id, 'SSL');
			
			$this->redirect($this->url->link('account/login', '', 'SSL'));
    	}
						
		$this->load->model('account/order');
//Retrieve selected order information.			
		$order_info = $this->model_account_order->getOrder($order_id);
		
		if ($order_info) {
			$this->document->setTitle($this->language->get('text_order'));
//Short-hand links to the path as breadcrumbs			
			$this->data['breadcrumbs'] = array();
		
			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_home'),
				'href'      => $this->url->link('common/home'),        	
				'separator' => false
			); 
		
			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_account'),
				'href'      => $this->url->link('account/account', '', 'SSL'),        	
				'separator' => $this->language->get('text_separator')
			);
			
			$url = '';
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
						
			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('account/order', $url, 'SSL'),      	
				'separator' => $this->language->get('text_separator')
			);
			
			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_order'),
				'href'      => $this->url->link('account/order/info', 'order_id=' . $this->request->get['order_id'] . $url, 'SSL'),
				'separator' => $this->language->get('text_separator')
			);
//Assigning page variables.					
      		$this->data['heading_title'] = $this->language->get('text_order');
			
			$this->data['text_order_detail'] = $this->language->get('text_order_detail');
			$this->data['text_invoice_no'] = $this->language->get('text_invoice_no');
    		$this->data['text_order_id'] = $this->language->get('text_order_id');
			$this->data['text_date_added'] = $this->language->get('text_date_added');
			$this->data['text_time_added'] = $this->language->get('text_time_added');
      		$this->data['text_shipping_method'] = $this->language->get('text_shipping_method');
			$this->data['text_shipping_address'] = $this->language->get('text_shipping_address');
      		$this->data['text_payment_method'] = $this->language->get('text_payment_method');
      		$this->data['text_payment_address'] = $this->language->get('text_payment_address');
      		$this->data['text_history'] = $this->language->get('text_history');
			$this->data['text_comment'] = $this->language->get('text_comment');

      		$this->data['column_name'] = $this->language->get('column_name');
      		$this->data['column_model'] = $this->language->get('column_model');
      		$this->data['column_quantity'] = $this->language->get('column_quantity');
      		$this->data['column_subscription'] = $this->language->get('column_subscription');
      		$this->data['column_price'] = $this->language->get('column_price');
      		$this->data['column_total'] = $this->language->get('column_total');
			$this->data['column_action'] = $this->language->get('column_action');
			$this->data['column_date_added'] = $this->language->get('column_date_added');
      		$this->data['column_status'] = $this->language->get('column_status');
      		$this->data['column_comment'] = $this->language->get('column_comment');
//Assigning links to the button			
			$this->data['button_return'] = $this->language->get('button_return');
      		$this->data['button_continue'] = $this->language->get('button_continue');
//Assigning order variables.		
			if ($order_info['invoice_no']) {
				$this->data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
			} else {
				$this->data['invoice_no'] = '';
			}
			$this->data['CASNO'] = $this->customer->getCASNO();
			$this->data['STBNO'] = $this->customer->getSTBNO();

			$this->data['order_id'] = $this->request->get['order_id'];
			$this->data['date_added'] = date($this->language->get('date_format_short'), strtotime($order_info['date_added']));
			$this->data['time_added'] = substr($order_info['date_added'],10);
			
			if ($order_info['payment_address_format']) {
      			$format = $order_info['payment_address_format'];
    		} else {
				$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
			}
		
    		$find = array(
	  			'{firstname}',
	  			'{lastname}',
	  			'{company}',
      			'{address_1}',
      			'{address_2}',
     			'{city}',
      			'{postcode}',
      			'{zone}',
				'{zone_code}',
      			'{country}'
			);
	
			$replace = array(
	  			'firstname' => $order_info['payment_firstname'],
	  			'lastname'  => $order_info['payment_lastname'],
	  			'company'   => $order_info['payment_company'],
      			'address_1' => $order_info['payment_address_1'],
      			'address_2' => $order_info['payment_address_2'],
      			'city'      => $order_info['payment_city'],
      			'postcode'  => $order_info['payment_postcode'],
      			'zone'      => $order_info['payment_zone'],
				'zone_code' => $order_info['payment_zone_code'],
      			'country'   => $order_info['payment_country']  
			);
			
			$this->data['payment_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

      		$this->data['payment_method'] = $order_info['payment_method'];
			
			if ($order_info['shipping_address_format']) {
      			$format = $order_info['shipping_address_format'];
    		} else {
				$format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
			}
		
    		$find = array(
	  			'{firstname}',
	  			'{lastname}',
	  			'{company}',
      			'{address_1}',
      			'{address_2}',
     			'{city}',
      			'{postcode}',
      			'{zone}',
				'{zone_code}',
      			'{country}'
			);
	
			$replace = array(
	  			'firstname' => $order_info['shipping_firstname'],
	  			'lastname'  => $order_info['shipping_lastname'],
	  			'company'   => $order_info['shipping_company'],
      			'address_1' => $order_info['shipping_address_1'],
      			'address_2' => $order_info['shipping_address_2'],
      			'city'      => $order_info['shipping_city'],
      			'postcode'  => $order_info['shipping_postcode'],
      			'zone'      => $order_info['shipping_zone'],
				'zone_code' => $order_info['shipping_zone_code'],
      			'country'   => $order_info['shipping_country']  
			);

			$this->data['shipping_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

			$this->data['shipping_method'] = $order_info['shipping_method'];
			
			$this->data['products'] = array();
//Retrieve products added to the  selected order.			
			$products = $this->model_account_order->getOrderProducts($this->request->get['order_id']);

      		foreach ($products as $product) {
				$option_data = array();
				
				$options = $this->model_account_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);

         		foreach ($options as $option) {
          			if ($option['type'] != 'file') {
						$value = $option['value'];
					} else {
						$value = utf8_substr($option['value'], 0, utf8_strrpos($option['value'], '.'));
					}
					
					$option_data[] = array(
						'name'  => $option['name'],
						'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value)
					);					
        		}
//Assign selected product information to an array.
        		$this->data['products'][] = array(
          			'name'     => $product['name'],
          			'model'    => $product['model'],
          			'option'   => $option_data,
          			'quantity' => $product['quantity'],
          			'price'    => $this->currency->format($product['price'] + ($this->config->get('config_tax') ? $product['tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
					'total'    => $this->currency->format($product['total'] + ($this->config->get('config_tax') ? ($product['tax'] * $product['quantity']) : 0), $order_info['currency_code'], $order_info['currency_value']),
					'return'   => $this->url->link('account/return/insert', 'order_id=' . $order_info['order_id'] . '&product_id=' . $product['product_id'], 'SSL')
        		);
      		}

// Voucher
			$this->data['vouchers'] = array();
//Retrieving vouchers if any against the order.			
			$vouchers = $this->model_account_order->getOrderVouchers($this->request->get['order_id']);
			
			foreach ($vouchers as $voucher) {
				$this->data['vouchers'][] = array(
					'description' => $voucher['description'],
					'amount'      => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
				);
			}
//Assigning total variable.			
      		$this->data['totals'] = $this->model_account_order->getOrderTotals($this->request->get['order_id']);
			
			$this->data['comment'] = nl2br($order_info['comment']);
			
			$this->data['histories'] = array();
//Retrieving order history made by the customer.
			$results = $this->model_account_order->getOrderHistories($this->request->get['order_id']);
			
//Assiging history detail to an array
      		foreach ($results as $result) {
        		$this->data['histories'][] = array(
          			'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
          			'status'     => $result['status'],
          			'comment'    => nl2br($result['comment'])
        		);
      		}

      		$this->data['continue'] = $this->url->link('account/order', '', 'SSL');
      		$this->data['printPdf'] = $this->url->link('account/order/printPdf', '&order_id=' . (int)$this->request->get['order_id'], 'SSL');

/*Check if the template file other than the default theme for the order_info exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the order_info
*/
		
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/account/order_info.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/account/order_info.tpl';
			} else {
				$this->template = 'default/template/account/order_info.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'	
			);
								
			$this->response->setOutput($this->render());		
    	} else {
//if order information was not found.
			$this->document->setTitle($this->language->get('text_order'));
			
      		$this->data['heading_title'] = $this->language->get('text_order');

      		$this->data['text_error'] = $this->language->get('text_error');

      		$this->data['button_continue'] = $this->language->get('button_continue');
			
			$this->data['breadcrumbs'] = array();
//Short-hand links to the path as breadcrumbs.
			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_home'),
				'href'      => $this->url->link('common/home'),
				'separator' => false
			);
			
			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_account'),
				'href'      => $this->url->link('account/account', '', 'SSL'),
				'separator' => $this->language->get('text_separator')
			);

			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('heading_title'),
				'href'      => $this->url->link('account/order', '', 'SSL'),
				'separator' => $this->language->get('text_separator')
			);
			
			$this->data['breadcrumbs'][] = array(
				'text'      => $this->language->get('text_order'),
				'href'      => $this->url->link('account/order/info', 'order_id=' . $order_id, 'SSL'),
				'separator' => $this->language->get('text_separator')
			);
												
      		$this->data['continue'] = $this->url->link('account/order', '', 'SSL');


/*Check if the template file other than the default theme for the not_found exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the not_found
*/			 			
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/error/not_found.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/error/not_found.tpl';
			} else {
				$this->template = 'default/template/error/not_found.tpl';
			}
			
			$this->children = array(
				'common/column_left',
				'common/column_right',
				'common/content_top',
				'common/content_bottom',
				'common/footer',
				'common/header'	
			);
								
			$this->response->setOutput($this->render());				
    	}
  	}


  	public function printPdf(){
       $this->load->model('account/order');
         $this->load->model('setting/setting');
        if (isset($this->request->get['order_id'])) {
			$order_id = $this->request->get['order_id'];
		}
        
        $order_info = $this->model_account_order->getOrder($order_id);
        
        if ($order_info) {
				$store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
				
				if ($store_info) {
					$store_address = $store_info['config_address'];
					$store_email = $store_info['config_email'];
					$store_telephone = $store_info['config_telephone'];
					$store_fax = $store_info['config_fax'];
				} else {
					$store_address = $this->config->get('config_address');
					$store_email = $this->config->get('config_email');
					$store_telephone = $this->config->get('config_telephone');
					$store_fax = $this->config->get('config_fax');
				}
			}
           $store_address .="Telphone:".$store_telephone."\n".$store_email."\n";
           
           $order_detail = "Invoice No.: ".$order_info['invoice_prefix'] . $order_info['invoice_no']."\n";
           $order_detail .= "Date Added: ".date($this->language->get('date_format_short'), strtotime($order_info['date_added']))."\n"; 
           $order_detail .= "Order ID: ".$order_info['order_id']."\n";
           $order_detail .= "Payment Method: ".$order_info['payment_method'];
           

           
           if ($order_info['payment_address_format']) {
					$format_payment = $order_info['payment_address_format'];
				} else {
					$format_payment = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
				}

		    if ($order_info['shipping_address_format']) {
					$format_shipping = $order_info['shipping_address_format'];
				} else {
					$format_shipping = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
				}

				$find = array(
					'{firstname}',
					'{lastname}',
					'{company}',
					'{address_1}',
					'{address_2}',
					'{city}',
					'{postcode}',
					'{zone}',
					'{zone_code}',
					'{country}'
				);

				$replace_payment = array(
					'firstname' => $order_info['payment_firstname'],
					'lastname'  => $order_info['payment_lastname'],
					'company'   => $order_info['payment_company'],
					'address_1' => $order_info['payment_address_1'],
					'address_2' => $order_info['payment_address_2'],
					'city'      => $order_info['payment_city'],
					'postcode'  => $order_info['payment_postcode'],
					'zone'      => $order_info['payment_zone'],
					'zone_code' => $order_info['payment_zone_code'],
					'country'   => $order_info['payment_country']
				);
                
                $replace_shipping = array(
					'firstname' => $order_info['shipping_firstname'],
					'lastname'  => $order_info['shipping_lastname'],
					'company'   => $order_info['shipping_company'],
					'address_1' => $order_info['shipping_address_1'],
					'address_2' => $order_info['shipping_address_2'],
					'city'      => $order_info['shipping_city'],
					'postcode'  => $order_info['shipping_postcode'],
					'zone'      => $order_info['shipping_zone'],
					'zone_code' => $order_info['shipping_zone_code'],
					'country'   => $order_info['shipping_country']
				);


				$payment_address = str_replace(array("\r\n", "\r", "\n"), "\n", preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), "\n", trim(str_replace($find, $replace_payment, $format_payment))))."\n";
				$payment_address .= $order_info['email']."\n".$order_info['telephone'];

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), "\n", preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), "\n", trim(str_replace($find, $replace_shipping, $format_shipping))))."\n";
				$shipping_address .= $order_info['email']."\n".$order_info['telephone'];
	       
	    $this->pdf->AddPage();
	    $this->pdf->Image(DIR_IMAGE.'/data/channels/logo.png',8,10,60);
	    $this->pdf->SetFillColor(232,232,232);

		$this->pdf->SetFont('times','',10);
		$this->pdf->SetY(20);
		$this->pdf->SetTextColor(204,204,204);
		$this->pdf->Cell(165,6,'INVOICE',0,0,'C',0);
		$this->pdf->SetDrawColor(188,188,188);
        $this->pdf->Line(5,25,205,25);
		$this->pdf->SetY(30);
        $this->pdf->SetTextColor(0,0,0);
	    $this->pdf->MultiCell(50,4,$store_address,0,1,0);
        $this->pdf->SetXY($this->pdf->getX()+130,26);
	    $this->pdf->MultiCell(60,4,$order_detail,0,1,0);

        $w = array(10, 90);
	    $c = array(95, 95);
	    $header =  array('TO','Ship To (if different address)');
		
		$this->pdf->ln(15);
	    for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	    	$this->pdf->SetX($w[0]);
	      else
		   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
		 
		   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
	    }
         
	     $this->pdf->Ln();
	     $this->pdf->MultiCell(95,4,$payment_address,1,1,0);
         
         $this->pdf->SetXY($this->pdf->getX()+95,67);
         $this->pdf->MultiCell(95,4,$payment_address,1,1,0);
	    
         
           $count=0;  

		 	$products = $this->model_account_order->getOrderProducts($this->request->get['order_id']);
		 	foreach ($products as $key => $product) {
				$option_data = array();
				$options = $this->model_account_order->getOrderOptionsInvoice($order_id, $product['order_product_id']);

				foreach ($options as $option) {
					if ($option['type'] != 'file') {
						$value = $option['value'];
					} else {
						$value = utf8_substr($option['value'], 0, utf8_strrpos($option['value'], '.'));
					}
					
					$option_data = array(
						'name'  => $option['name'],
						'value' => $value
					);								
				}
			}
			
			if($option_data)
				$subscribedFor = " (".$option_data['name'].'- '.$option_data['value'].")"; 
			else
				$subscribedFor ='';
            foreach($products as $product){
			$data[] = array($product['name'].$subscribedFor,$product['model'],"Rs. ".$product['price'],"Rs. ".$product['total']);
	      $count++;
        }

  $this->pdf->SetXY($this->pdf->GetX(),$this->pdf->GetY()+10);
  $w = array(10, 100, 130,160);
	    $c = array(90, 30, 30,40);
	    $header =  array('Product','Channel No#','Price','Total');
		$i=0;
		
	    for( $i = 0; $i < count($header) ; $i++){
		  if($i==0)
	    	$this->pdf->SetX($w[0]);
	      else
		   $this->pdf->SetX($w[$i-1]+$c[$i-1]);
		 
		   $this->pdf->Cell($c[$i],6,$header[$i],1,0,'L',1);
	    }
         $this->pdf->ln(6);
        
        for($i=0;$i<$count;$i++)
        {
          for($j=0; $j < count($header) ; $j++)
           $this->pdf->Cell($c[$j],6,$data[$i][$j],1,0,'L',0);
          $this->pdf->Ln();
        }
        $total_data = $this->model_account_order->getOrderTotals($order_id);
        
        //$this->pdf->SetX($this->pdf->getX()+100);
        foreach ($total_data as $total) {
        $this->pdf->Cell(150,6,$total['title'].":",1,0,'R',0);
        $temp = str_replace('₹','Rs. ',$total['text']);
        $this->pdf->Cell(40,6,$temp,1,0,'L',0);
        $this->pdf->Ln();
	    }
	    $this->pdf->Output();
        
    
    }
}
?>