<?php 
/*
@File edit.php(Controller)
CUSTOMER EDIT ACCOUNT PAGE
    Customer can edit the Personal details.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerAccountEdit extends Controller {

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the customers personal details. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Form with the filled details as specified by the customer.
*/	
	private $error = array();

	public function index() {

/*Checks if the customer is logged in or not, if not redirect him to login page.*/
		if (!$this->customer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('account/edit', '', 'SSL');

			$this->redirect($this->url->link('account/login', '', 'SSL'));
		}
//Loads the language file for edit.
		$this->language->load('account/edit');
		
		$this->document->setTitle($this->language->get('heading_title'));
// Loads the cutomer model 		
		$this->load->model('account/customer');
/*Check if the requested method is POST or not and the boolean value of validate function.
	If the condition id true, modified fields are updated in the database and redirected 
	to the account page. 

*/
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_account_customer->editCustomer($this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('account/account', '', 'SSL'));
		}
//Short-hand links to the path as breadcrumbs.
      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),     	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_edit'),
			'href'      => $this->url->link('account/edit', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
//Assigning variables 		
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_your_details'] = $this->language->get('text_your_details');

		$this->data['entry_firstname'] = $this->language->get('entry_firstname');
		$this->data['entry_lastname'] = $this->language->get('entry_lastname');
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_telephone'] = $this->language->get('entry_telephone');
		$this->data['entry_fax'] = $this->language->get('entry_fax');
		$this->data['entry_landline'] = $this->language->get('entry_landline');

		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_back'] = $this->language->get('button_back');
//Warning and Error variable assignments.
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}
		
		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}	
		
		if (isset($this->error['telephone'])) {
			$this->data['error_telephone'] = $this->error['telephone'];
		} else {
			$this->data['error_telephone'] = '';
		}	
		if (isset($this->error['landline'])) {
			$this->data['error_landline'] = $this->error['landline'];
		} else {
			$this->data['error_landline'] = '';
		}

		$this->data['action'] = $this->url->link('account/edit', '', 'SSL');
//Retrieve the customer information using his ID.
		if ($this->request->server['REQUEST_METHOD'] != 'POST') {
			$customer_info = $this->model_account_customer->getCustomer($this->customer->getId());
		}
// Assigning customer details to the variables.
		if (isset($this->request->post['firstname'])) {
			$this->data['firstname'] = $this->request->post['firstname'];
		} elseif (isset($customer_info)) {
			$this->data['firstname'] = $customer_info['firstname'];
		} else {
			$this->data['firstname'] = '';
		}

		if (isset($this->request->post['lastname'])) {
			$this->data['lastname'] = $this->request->post['lastname'];
		} elseif (isset($customer_info)) {
			$this->data['lastname'] = $customer_info['lastname'];
		} else {
			$this->data['lastname'] = '';
		}

		if (isset($this->request->post['email'])) {
			$this->data['email'] = $this->request->post['email'];
		} elseif (isset($customer_info)) {
			$this->data['email'] = $customer_info['email'];
		} else {
			$this->data['email'] = '';
		}

		if (isset($this->request->post['telephone'])) {
			$this->data['telephone'] = $this->request->post['telephone'];
		} elseif (isset($customer_info)) {
			$this->data['telephone'] = $customer_info['telephone'];
		} else {
			$this->data['telephone'] = '';
		}

		if (isset($this->request->post['landline'])) {
			$this->data['landline'] = $this->request->post['landline'];
		} elseif (isset($customer_info)) {
			$this->data['landline'] = $customer_info['landline'];
		} else {
			$this->data['landline'] = '';
		}

		if (isset($this->request->post['fax'])) {
			$this->data['fax'] = $this->request->post['fax'];
		} elseif (isset($customer_info)) {
			$this->data['fax'] = $customer_info['fax'];
		} else {
			$this->data['fax'] = '';
		}

		$this->data['back'] = $this->url->link('account/account', '', 'SSL');

/*Check if the template file other than the default theme for the edit exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the edit
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/account/edit.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/account/edit.tpl';
		} else {
			$this->template = 'default/template/account/edit.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
	}




/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validate the information specified by the customer 
						for updating.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns TRUE if the validation satisfies else returns FALSE
*/
	protected function validate() {

//validation of firstname		
		if ( $this->request->post['firstname']==''){
  			$this->error['firstname'] = $this->language->get('error_mandatory');
  		}
		else if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
		}
		else if ( $this->isValid($this->request->post['firstname'])){
  			$this->error['firstname'] = $this->language->get('Special Characters not allowed!');
  		}
//validation of lastname
		if ( $this->request->post['lastname']==''){
  			$this->error['lastname'] = $this->language->get('error_mandatory');
  		}
		else if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
			$this->error['lastname'] = $this->language->get('error_lastname');
		}
		else if ( $this->isValid($this->request->post['lastname'])){
  			$this->error['lastname']= $this->language->get('Special Characters not allowed!');
  		}
//validation of email
		/*if ( $this->request->post['email']==''){
  			$this->error['email'] = $this->language->get('error_mandatory');
  		}
		else*/
		if ( trim($this->request->post['email'])!=''){
			if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^([a-z0-9_\.-]+)@([\da-z\.-]+)\.([a-z\.]{2,6})$/i', $this->request->post['email'])) {
				$this->error['email'] = $this->language->get('error_email');
			}
			
			if (($this->customer->getEmail() != $this->request->post['email']) && $this->model_account_customer->getTotalCustomersByEmail($this->request->post['email'])) {
				$this->error['email'] = $this->language->get('error_exists');
			}
		}
//validation of telephone		
		if ( $this->request->post['telephone']==''){
  			$this->error['telephone'] = $this->language->get('error_mandatory');
  		}
		else {
			if (!preg_match("/^[1-9][0-9]*$/",$this->request->post['telephone']))
			{
				$this->error['telephone'] = $this->language->get('error_telephone_only_digits');
			}
			else if (utf8_strlen($this->request->post['telephone']) != 10)  {
				$this->error['telephone'] = $this->language->get('error_telephone');
			}
		}

		if($this->model_account_customer->isMobileDuplicate($this->request->post['telephone'])){ 
			$this->error['telephone'] = "Mobile No. already exist!";
		}

//validation of landline
		if ( $this->request->post['landline']!=''){
  		
			if (!preg_match("/^[1-9][0-9]*$/",$this->request->post['landline']))
			{
				$this->error['landline'] = $this->language->get('error_landline_only_digits');
			}
			else if (utf8_strlen($this->request->post['landline']) != 10)  {
				$this->error['landline'] = $this->language->get('error_landline');
			}
		}
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

	public function isValid($str) {
    	return preg_match('/[^A-Za-z0-9]/', $str);
	}
}
?>