<?php 
/*@File box.php(Controller)
CUSTOMER STB PAGE
    This class displays the STB and CAS number associated with the customer. 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerAccountBox extends Controller {

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Check for the login authentication and then retrieves the 
						STB and CAS number of the customer.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Render the box page with STB and CAS number.
*/

	private $error = array();

	public function index() {
/*Checks if the customer is logged in or not, if not redirect him to login page.*/
		if (!$this->customer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('account/box', '', 'SSL');

			$this->redirect($this->url->link('account/login', '', 'SSL'));
		}
//Loading the language file for box
		$this->language->load('account/box');
		
		$this->document->setTitle($this->language->get('heading_title'));
//Loading the customer model to retrieve the STB and CAS number.		
		$this->load->model('account/customer');
// Short-hand link to the path travelled.
      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),     	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_box'),
			'href'      => $this->url->link('account/box', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
//Retrieving the STB and CAS number from the database.		
		$this->data['STBNO']= $this->customer->getSTBNO();
		$this->data['CASNO']= $this->customer->getCASNO();
		$this->data['SCNO']= $this->customer->getSCNO();
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_box_title'] = $this->language->get('text_box_title');

//Buttons for continue and back.
		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_back'] = $this->language->get('button_back');
//Error and warning checking if any.
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		$this->data['action'] = $this->url->link('account/box', '', 'SSL');

		$this->data['back'] = $this->url->link('account/account', '', 'SSL');

/*Check if the template file other than the default theme for the box exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the box
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/account/box.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/account/box.tpl';
		} else {
			$this->template = 'default/template/account/box.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
	}

	
}
?>